/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft")
public final class DropConsumer {
    private static Function<ItemStack, ItemStack> dropConsumer;
    private static List<ItemStack> remainingDrops;
    private static Level dropWorld;
    private static AABB dropBounds;
    private static Entity dropEntity;

    private DropConsumer() {
    }

    public static void set(Entity entity, Function<ItemStack, ItemStack> consumer) {
        dropConsumer = consumer;
        remainingDrops = new ArrayList<ItemStack>();
        dropEntity = entity;
        dropWorld = entity.f_19853_;
        dropBounds = new AABB(entity.m_142538_()).m_82377_(2.0, 2.0, 2.0);
    }

    public static void set(Level world, BlockPos pos, Function<ItemStack, ItemStack> consumer) {
        dropConsumer = consumer;
        remainingDrops = new ArrayList<ItemStack>(2);
        dropEntity = null;
        dropWorld = world;
        dropBounds = new AABB(pos).m_82377_(2.0, 2.0, 2.0);
    }

    public static List<ItemStack> clear() {
        List<ItemStack> remainingStacks = remainingDrops;
        dropConsumer = null;
        remainingDrops = null;
        dropEntity = null;
        dropWorld = null;
        dropBounds = null;
        return remainingStacks;
    }

    public static void clearAndDrop(Level world, BlockPos pos, Direction direction) {
        List<ItemStack> remainingDrops = DropConsumer.clear();
        for (ItemStack remaining : remainingDrops) {
            WorldUtil.dropItemStack(remaining, world, pos, direction);
        }
    }

    private static void handleDrops(ItemStack stack) {
        ItemStack remaining = dropConsumer.apply(stack);
        if (!remaining.m_41619_()) {
            remainingDrops.add(remaining);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        if (dropWorld == event.getWorld() && event.getEntity() instanceof ItemEntity && dropBounds.m_82390_(event.getEntity().m_20182_())) {
            DropConsumer.handleDrops(((ItemEntity)event.getEntity()).m_32055_());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingDrops(LivingDropsEvent drops) {
        if (dropEntity == null || drops.getEntity() != dropEntity) {
            return;
        }
        for (ItemEntity drop : drops.getDrops()) {
            DropConsumer.handleDrops(drop.m_32055_());
        }
        drops.getDrops().clear();
        drops.setCanceled(true);
    }
}

